/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	CreateLineEndToCenter.cpp

#include <stdafx.h>

#include "cUtility.h"
#include "cApplication.h"
#include "cLine.h"

//	Creates a line using the end point of the given line and the
//	center point of the given circle and returns the line created
//	After creation the line is AutoConstrained.

HRESULT CreateLineEndToCenter(ILine *line1, ILine *circle1, ILine **newLine1)
{

	START_METHOD("CreateLineEndToCenter")

	HRESULT status = CONV_SUCCESS;
	
	// Get the end point of the line
	IPoint *endPoint1 = NULL;
	status = line1->GetEndPoint(&endPoint1);
	CHECK_RETURN_STATUS(status)

	// Get the center point of the circle
	IPoint *centerPoint1 = NULL;
	status = circle1->GetCenterPoint(&centerPoint1);
	CHECK_RETURN_STATUS(status)

	ILine *pLine1 = NULL;
	status = CreateLinePointToPoint(endPoint1, centerPoint1, &pLine1);
	CHECK_RETURN_STATUS(status)

	*newLine1 = pLine1;

	END_METHOD("CreateLineEndToCenter")
}
